local t = LoadFallbackB();
local ScoreLabels = { "(PERFECT) W1", "(PERFECT) W2", "(GREAT) W3", "(GOOD) W4", "(BAD) W5" }

local MQValues = {
	string.format("%0.4f",0.0125),
	string.format("%0.4f",0.0250),
	string.format("%0.4f",0.0500),
	string.format("%0.4f",0.1000),
	string.format("%0.4f",0)
}

local SM5Values = {
	string.format("%0.4f",0.0225),
	string.format("%0.4f",0.0450),
	string.format("%0.4f",0.0900),
	string.format("%0.4f",0.1350),
	string.format("%0.4f",0.1800)
}

local cValues = {
	string.format("%0.4f",PREFSMAN:GetPreference("TimingWindowSecondsW1")),
	string.format("%0.4f",PREFSMAN:GetPreference("TimingWindowSecondsW2")),
	string.format("%0.4f",PREFSMAN:GetPreference("TimingWindowSecondsW3")),
	string.format("%0.4f",PREFSMAN:GetPreference("TimingWindowSecondsW4")),
	string.format("%0.4f",PREFSMAN:GetPreference("TimingWindowSecondsW5")),
}

t[#t+1] = Def.ActorFrame {
	CommonNormal()..{
		Text="CURRENT TIMING WINDOWS:";
		InitCommand=cmd(xy,CenterX()-172,CenterY()-84;zoom,0.5;valign,0;maxwidth,356);
	};
	CommonNormal()..{
		Text="Those values will be saved to Preferences.ini";
		InitCommand=cmd(xy,CenterX()-172,CenterY()+60;zoom,0.5;valign,0;maxwidth,384);
	};
	CommonNormal()..{
		Text="Those Values will be used!";
		InitCommand=cmd(xy,CenterX()+172,CenterY()+60;zoom,0.5;valign,0;maxwidth,384);
	};
	CommonNormal()..{
		Text="WARNING: Those values will still being used if you change of Theme!";
		InitCommand=cmd(xy,CenterX(),Bottom()-58;zoom,0.5;valign,0;diffuseshift;effectperiod,0.5;effectcolor1,color("1,0.95,0.8,1");effectcolor2,color("0.8,0.95,1,1"));
	};
};

for i = 1,#ScoreLabels do
	t[#t+1] = Def.ActorFrame {
		CommonNormal()..{ -- Current Timing Titles
			Text=ScoreLabels[i];
			InitCommand=cmd(xy,CenterX()-256,CenterY()-84+(24*i);zoom,0.5;align,0,0;maxwidth,356;diffuse,color(jColors[i]));
		};
		CommonNormal()..{ -- Current Timing Values
			Text=cValues[i];
			InitCommand=cmd(xy,CenterX()-64,CenterY()-84+(24*i);zoom,0.5;align,0,0;maxwidth,356;diffuse,Black());
		};
		CommonNormal()..{ -- Target Timing Titles
			Text=ScoreLabels[i];
			InitCommand=cmd(xy,CenterX()+256,CenterY()-84+(24*i);zoom,0.5;align,1,0;maxwidth,356;diffuse,color(jColors[i]));
		};
		Def.Quad{ -- Current Timing Label Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()-172,CenterY()-88+(24*i);valign,0;setsize,200,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)); 
		};
		Def.Quad{ -- Current Timing Value Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()-68,CenterY()-88+(24*i);align,0,0;setsize,60,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)); 
		};
		Def.Quad{ -- Target Timing Label Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()+172,CenterY()-88+(24*i);valign,0;setsize,200,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2)); 
		};
		Def.Quad{ -- Target Timing Value Quads
			InitCommand=cmd(draworder,-1;xy,CenterX()+68,CenterY()-88+(24*i);align,1,0;setsize,60,20;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)); 
		};
	};
end

local Option = ThemePrefs.Get("TimingWindow")
local TargetTimingTitle
local TargetTimingW1, TargetTimingW2, TargetTimingW3, TargetTimingW4, TargetTimingW5
local AbleToMoveLeft = (Option == "MQX") and 1 or 0
local AbleToMoveRight = (Option == "MQX") and 0 or 1

local function InitialTimingText() if Option == "MQX" then return "METRO QUAD X TIMING WINDOW" else return "STEPMANIA 5 TIMING WINDOW" end end
local function CurrentTimingTargetValue(i) if Option == "MQX" then return MQValues[i] else return SM5Values[i] end end

local function TargetTimingCallback(event)
	local pn = event.PlayerNumber
	if event.type == "InputEventType_FirstPress" then
		if pn then
			if event.GameButton == "MenuLeft" then
				AbleToMoveLeft = AbleToMoveLeft - 1
				AbleToMoveRight = AbleToMoveRight + 1
				if AbleToMoveLeft >= 2 or AbleToMoveLeft <= -1 then AbleToMoveLeft = 1 AbleToMoveRight = 0 end
			end
			if event.GameButton == "MenuRight" then
				AbleToMoveLeft = AbleToMoveLeft + 1
				AbleToMoveRight = AbleToMoveRight - 1
				if AbleToMoveRight >= 2 or AbleToMoveRight <= -1 then AbleToMoveLeft = 0 AbleToMoveRight = 1 end
			end
			if AbleToMoveLeft > 0 then TargetTimingTitle:settext("METRO QUAD X SCORE WEIGHTS") else TargetTimingTitle:settext("STEPMANIA 5 SCORE WEIGHTS") end
			if AbleToMoveLeft > 0 then TargetTimingW1:settext(MQValues[1]) else TargetTimingW1:settext(SM5Values[1]) end
			if AbleToMoveLeft > 0 then TargetTimingW2:settext(MQValues[2]) else TargetTimingW2:settext(SM5Values[2]) end
			if AbleToMoveLeft > 0 then TargetTimingW3:settext(MQValues[3]) else TargetTimingW3:settext(SM5Values[3]) end
			if AbleToMoveLeft > 0 then TargetTimingW4:settext(MQValues[4]) else TargetTimingW4:settext(SM5Values[4]) end
			if AbleToMoveLeft > 0 then TargetTimingW5:settext(MQValues[5]) else TargetTimingW5:settext(SM5Values[5]) end
		end
	end
end

t[#t+1] = Def.ActorFrame {
	CommonNormal()..{
		Text=InitialTimingText();
		InitCommand=cmd(xy,CenterX()+172,CenterY()-84;zoom,0.5;valign,0;maxwidth,356);
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetTimingCallback) TargetTimingTitle=self end;
	};
	CommonNormal()..{
		Text=CurrentTimingTargetValue(1);
		InitCommand=cmd(xy,CenterX()+64,CenterY()-84+24;zoom,0.5;align,1,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetTimingCallback) TargetTimingW1=self end;
	};
	CommonNormal()..{
		Text=CurrentTimingTargetValue(2);
		InitCommand=cmd(xy,CenterX()+64,CenterY()-84+24*2;zoom,0.5;align,1,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetTimingCallback) TargetTimingW2=self end;
	};
	CommonNormal()..{
		Text=CurrentTimingTargetValue(3);
		InitCommand=cmd(xy,CenterX()+64,CenterY()-84+24*3;zoom,0.5;align,1,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetTimingCallback) TargetTimingW3=self end;
	};
	CommonNormal()..{
		Text=CurrentTimingTargetValue(4);
		InitCommand=cmd(xy,CenterX()+64,CenterY()-84+24*4;zoom,0.5;align,1,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetTimingCallback) TargetTimingW4=self end;
	};
	CommonNormal()..{
		Text=CurrentTimingTargetValue(5);
		InitCommand=cmd(xy,CenterX()+64,CenterY()-84+24*5;zoom,0.5;align,1,0;diffuse,Black());
		OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(TargetTimingCallback) TargetTimingW5=self end;
	};
};

return t